package ru.yandex.direct.jooqmapper;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;

@ParametersAreNonnullByDefault
public interface JooqModelToDbMapper<M> {
    /**
     * С помощью предварительно заданнных райтеров вычисляет из данных модели поля в базе
     *
     * @param model экземпляр модели
     * @param table таблица
     * @return возвращает мапу значение по полю таблицы.
     */
    <R extends Record> Map<TableField<R, ?>, ?> getDbFieldValues(M model, Table<R> table);
}
