package ru.yandex.direct.jooqmapper;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.read.ReaderFunction1;
import ru.yandex.direct.jooqmapper.write.WriterFunction1;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class JsonReaderWriterBuilder<M extends Model, T, X extends Record> {

    private final ModelProperty<? super M, T> property;
    private final TableField<X, String> field;
    private final String jsonPath;
    private final ReaderFunction1<JsonNode, T> readerFunction;
    private final WriterFunction1<T, JsonNode> writerFunction;

    private JsonReaderWriterBuilder(ModelProperty<? super M, T> property,
                                    TableField<X, String> field,
                                    String jsonPath,
                                    ReaderFunction1<JsonNode, T> readerFunction,
                                    WriterFunction1<T, JsonNode> writerFunction) {
        this.property = property;
        this.field = field;
        this.jsonPath = jsonPath;
        this.readerFunction = readerFunction;
        this.writerFunction = writerFunction;
    }

    static <M extends Model, T, X extends Record> JsonReaderWriterBuilder<M, T, X> convertibleJsonProperty(
            ModelProperty<? super M, T> modelProperty,
            TableField<X, String> field,
            String jsonPath,
            ReaderFunction1<JsonNode, T> readerFunction,
            WriterFunction1<T, JsonNode> writerFunction) {
        return new JsonReaderWriterBuilder<>(modelProperty, field, jsonPath, readerFunction, writerFunction);
    }

    ModelProperty<? super M, T> getProperty() {
        return property;
    }

    TableField<X, String> getField() {
        return field;
    }


    String getJsonPath() {
        return jsonPath;
    }

    ReaderFunction1<JsonNode, T> getReaderFunction() {
        return readerFunction;
    }

    WriterFunction1<T, JsonNode> getWriterFunction() {
        return writerFunction;
    }
}
