package ru.yandex.direct.jooqmapper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.jsonread.JsonReaderBuilders;
import ru.yandex.direct.jooqmapper.jsonwrite.JsonWriterBuilders;
import ru.yandex.direct.jooqmapper.read.ReaderFunction1;
import ru.yandex.direct.jooqmapper.write.WriterFunction1;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Для построения {@link JooqMapper} используйте {@link JooqMapperBuilder}.
 */
public final class JsonReaderWriterBuilders {
    private JsonReaderWriterBuilders() {
    }

    public static <M extends Model, T, X extends Record> JsonReaderWriterBuilder<M, T, X> convertibleJsonProperty(
            ModelProperty<? super M, T> modelProperty,
            TableField<X, String> field,
            String jsonPath,
            ReaderFunction1<JsonNode, T> readerFunction,
            WriterFunction1<T, JsonNode> writerFunction) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(modelProperty, field, jsonPath, readerFunction,
                writerFunction);
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, Boolean, X> jsonBoolean(
            ModelProperty<? super M, Boolean> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::jsonNodeToBoolean,
                JsonWriterBuilders::booleanToJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, Boolean, X> jsonBooleanToLong(
            ModelProperty<? super M, Boolean> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::longJsonNodeToBoolean,
                JsonWriterBuilders::booleanToLongJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, Integer, X> jsonInteger(
            ModelProperty<? super M, Integer> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::jsonNodeToInteger,
                JsonWriterBuilders::integerToJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, Long, X> jsonLong(
            ModelProperty<? super M, Long> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::jsonNodeToLong,
                JsonWriterBuilders::longToJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, String, X> jsonString(
            ModelProperty<? super M, String> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::jsonNodeToString,
                JsonWriterBuilders::stringToJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, LocalDateTime, X> jsonLocalDateTime(
            ModelProperty<? super M, LocalDateTime> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::stringJsonNodeToLocalDateTime,
                JsonWriterBuilders::localDateTimeToStringJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, LocalDate, X> jsonLocalDate(
            ModelProperty<? super M, LocalDate> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::stringJsonNodeToLocalDate,
                JsonWriterBuilders::localDateToStringJsonNode
        );
    }

    public static <M extends Model, X extends Record> JsonReaderWriterBuilder<M, BigDecimal, X> jsonBigDecimal(
            ModelProperty<? super M, BigDecimal> modelProperty,
            TableField<X, String> field,
            String jsonPath) {
        return JsonReaderWriterBuilder.convertibleJsonProperty(
                modelProperty,
                field,
                jsonPath,
                JsonReaderBuilders::readBigDecimalAnyOfType,
                JsonWriterBuilders::bigDecimalToStringJsonNode
        );
    }

}
