package ru.yandex.direct.jooqmapper;

import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.read.ReaderFunction1;
import ru.yandex.direct.jooqmapper.write.WriterFunction1;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class ReaderWriterBuilder<M extends Model, T, X extends Record, R> {

    private ModelProperty<? super M, T> property;
    private TableField<X, R> field;
    private ReaderFunction1<R, T> readerFunction;
    private WriterFunction1<T, R> writerFunction;

    private ReaderWriterBuilder(ModelProperty<? super M, T> property, TableField<X, R> field,
                                ReaderFunction1<R, T> readerFunction,
                                WriterFunction1<T, R> writerFunction) {
        this.property = property;
        this.field = field;
        this.readerFunction = readerFunction;
        this.writerFunction = writerFunction;
    }

    static <M extends Model, T, X extends Record, R> ReaderWriterBuilder<M, T, X, R> convertibleProperty(
            ModelProperty<? super M, T> modelProperty,
            TableField<X, R> field,
            ReaderFunction1<R, T> readerFunction,
            WriterFunction1<T, R> writerFunction) {
        return new ReaderWriterBuilder<>(modelProperty, field, readerFunction, writerFunction);
    }

    static <M extends Model, T, X extends Record> ReaderWriterBuilder<M, T, X, T> property(
            ModelProperty<? super M, T> modelProperty,
            TableField<X, T> field) {
        return new ReaderWriterBuilder<>(modelProperty, field, t -> t, t -> t);
    }

    ModelProperty<? super M, T> getProperty() {
        return property;
    }

    TableField<X, R> getField() {
        return field;
    }

    ReaderFunction1<R, T> getReaderFunction() {
        return readerFunction;
    }

    WriterFunction1<T, R> getWriterFunction() {
        return writerFunction;
    }
}
