package ru.yandex.direct.jooqmapper;

import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.read.ReaderFunction1;
import ru.yandex.direct.jooqmapper.write.WriterFunction1;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Для построения {@link JooqMapper} используйте {@link JooqMapperBuilder}.
 */
public final class ReaderWriterBuilders {
    private ReaderWriterBuilders() {
    }

    public static <M extends Model, T, X extends Record, R> ReaderWriterBuilder<M, T, X, R> convertibleProperty(
            ModelProperty<? super M, T> modelProperty,
            TableField<X, R> field,
            ReaderFunction1<R, T> readerFunction,
            WriterFunction1<T, R> writerFunction) {
        return ReaderWriterBuilder.convertibleProperty(modelProperty, field, readerFunction, writerFunction);
    }

    public static <M extends Model, T, X extends Record> ReaderWriterBuilder<M, T, X, T> property(
            ModelProperty<? super M, T> modelProperty,
            TableField<X, T> field) {
        return ReaderWriterBuilder.property(modelProperty, field);
    }


}
