package ru.yandex.direct.jooqmapper.commonread;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.jooqmapper.jsonread.JooqJsonReader;
import ru.yandex.direct.jooqmapper.jsonread.JooqJsonReaderBuilder;
import ru.yandex.direct.jooqmapper.jsonread.JsonReader1Builder;
import ru.yandex.direct.jooqmapper.read.DefaultReaderBuilder;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;
import ru.yandex.direct.jooqmapper.read.Reader1Builder;
import ru.yandex.direct.jooqmapper.read.Reader2Builder;
import ru.yandex.direct.jooqmapper.read.Reader3Builder;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Билдер для создания {@link CommonReader}.
 */
public class CommonReaderBuilder<M extends Model> {

    protected final JooqReaderBuilder<M> jooqReaderBuilder;
    protected final JooqJsonReaderBuilder<M> jooqJsonReaderBuilder;

    protected CommonReaderBuilder(
            @Nullable JooqReader<? super M> jooqReader,
            @Nullable JooqJsonReader<? super M> jooqJsonReader
    ) {
        jooqReaderBuilder = jooqReader != null ?
                JooqReaderBuilder.builder(jooqReader) : JooqReaderBuilder.builder();
        jooqJsonReaderBuilder = jooqJsonReader != null ?
                JooqJsonReaderBuilder.builder(jooqJsonReader) : JooqJsonReaderBuilder.builder();
    }

    protected CommonReaderBuilder(
            List<? extends JooqReader<? super M>> jooqReaders,
            List<? extends JooqJsonReader<? super M>> jooqJsonReaders
    ) {
        jooqReaderBuilder = JooqReaderBuilder.builder(jooqReaders);
        jooqJsonReaderBuilder = JooqJsonReaderBuilder.builder(jooqJsonReaders);
    }

    protected CommonReaderBuilder(
            @Nullable JooqReaderBuilder<M> jooqReaderBuilder
    ) {
        this.jooqReaderBuilder = jooqReaderBuilder != null ? jooqReaderBuilder : JooqReaderBuilder.builder();
        this.jooqJsonReaderBuilder = JooqJsonReaderBuilder.builder();
    }

    public static <M extends Model> CommonReaderBuilder<M> builder() {
        return new CommonReaderBuilder<>((JooqReader<? super M>) null, null);
    }

    public static <M extends Model> CommonReaderBuilder<M> builder(
            JooqReader<? super M> jooqReader) {
        return new CommonReaderBuilder<>(jooqReader, null);
    }

    public static <M extends Model> CommonReaderBuilder<M> builder(
            JooqJsonReader<? super M> jooqJsonReader) {
        return new CommonReaderBuilder<>(null, jooqJsonReader);
    }

    public static <M extends Model> CommonReaderBuilder<M> builder(
            JooqReader<? super M> jooqReader, JooqJsonReader<? super M> jooqJsonReader) {
        return new CommonReaderBuilder<>(jooqReader, jooqJsonReader);
    }

    public static <M extends Model> CommonReaderBuilder<M> builder(
            JooqReaderBuilder<M> readerBuilder) {
        return new CommonReaderBuilder<>(readerBuilder);
    }

    public static <M extends Model> CommonReaderBuilder<M> builder(
            CommonReader<? super M> commonReader) {
        return new CommonReaderBuilder<>(commonReader.getJooqReader(), commonReader.getJooqJsonReader());
    }

    public static <M extends Model> CommonReaderBuilder<M> builder(List<? extends CommonReader<? super M>> commonReaders) {
        List<? extends JooqReader<? super M>> jooqReaders = mapList(commonReaders, CommonReader::getJooqReader);

        List<? extends JooqJsonReader<? super M>> jooqJsonReaders =
                mapList(commonReaders, CommonReader::getJooqJsonReader);

        return new CommonReaderBuilder<>(jooqReaders, jooqJsonReaders);
    }

    public <T, R> CommonReaderBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                      Reader1Builder<R, T> reader1Builder) {
        jooqReaderBuilder.readProperty(modelProperty, reader1Builder);
        return this;
    }

    public <T> CommonReaderBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                   Reader1Builder.Reader1WithFieldStep<T> reader1Builder) {
        jooqReaderBuilder.readProperty(modelProperty, reader1Builder);
        return this;
    }

    public <T, R1, R2> CommonReaderBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                           Reader2Builder<R1, R2, T> reader2Builder) {
        jooqReaderBuilder.readProperty(modelProperty, reader2Builder);
        return this;
    }

    public <T, R1, R2, R3> CommonReaderBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                               Reader3Builder<R1, R2, R3, T> reader3Builder) {
        jooqReaderBuilder.readProperty(modelProperty, reader3Builder);
        return this;
    }

    public <T> CommonReaderBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                   DefaultReaderBuilder<T> readerBuilder) {
        jooqReaderBuilder.readProperty(modelProperty, readerBuilder);
        return this;
    }

    public <T> CommonReaderBuilder<M> readJsonProperty(ModelProperty<? super M, T> modelProperty,
                                                       JsonReader1Builder<T> reader1Builder) {
        jooqJsonReaderBuilder.readJsonProperty(modelProperty, reader1Builder);
        return this;
    }

    public CommonReader<M> build() {
        return new CommonReader<>(
                jooqReaderBuilder.isEmpty() ? null : jooqReaderBuilder.build(),
                jooqJsonReaderBuilder.isEmpty() ? null : jooqJsonReaderBuilder.build()
        );
    }

    public JooqReaderBuilder<M> getJooqReaderBuilder() {
        return jooqReaderBuilder;
    }

    public JooqJsonReaderBuilder<M> getJooqJsonReaderBuilder() {
        return jooqJsonReaderBuilder;
    }
}
