package ru.yandex.direct.jooqmapper.commonread;

import java.util.List;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;
import org.jooq.Record;

import ru.yandex.direct.jooqmapper.jsonread.JooqJsonReader;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Objects.requireNonNull;

@ParametersAreNonnullByDefault
public class CommonReaderWithSupplier<M extends Model> extends CommonReader<M> {

    private final Supplier<M> modelSupplier;

    public CommonReaderWithSupplier(@Nullable JooqReader<M> jooqReader, @Nullable JooqJsonReader<M> jooqJsonReader,
                                    Supplier<M> modelSupplier) {
        super(jooqReader, jooqJsonReader);
        this.modelSupplier = requireNonNull(modelSupplier, "model supplier is required");

    }

    public M fromDb(Record record) {
        return fromDb(record, modelSupplier.get());
    }

    public M fromDb(Record record, List<ModelProperty<? super M, ?>> modelProperties) {
        return fromDb(record, modelSupplier.get(), modelProperties);
    }
}
