package ru.yandex.direct.jooqmapper.commonread;

import java.util.function.Supplier;

import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;
import ru.yandex.direct.model.Model;

import static java.util.Objects.requireNonNull;

public class CommonReaderWithSupplierBuilder<M extends Model> extends CommonReaderBuilder<M> {

    private final Supplier<M> modelSupplier;

    private CommonReaderWithSupplierBuilder(Supplier<M> modelSupplier) {
        super(JooqReaderWithSupplierBuilder.builder(modelSupplier));
        this.modelSupplier = requireNonNull(modelSupplier, "model supplier is required");
    }

    private CommonReaderWithSupplierBuilder(CommonReader<? super M> commonReader, Supplier<M> modelSupplier) {
        super(JooqReaderWithSupplierBuilder.builder(commonReader.getJooqReader(), modelSupplier));
        this.modelSupplier = requireNonNull(modelSupplier, "model supplier is required");
    }

    public static <M extends Model> CommonReaderWithSupplierBuilder<M> builder(Supplier<M> modelSupplier) {
        return new CommonReaderWithSupplierBuilder<>(modelSupplier);
    }

    public static <M extends Model> CommonReaderWithSupplierBuilder<M> builder(
            CommonReader<? super M> commonReader, Supplier<M> modelSupplier) {
        return new CommonReaderWithSupplierBuilder<>(commonReader, modelSupplier);
    }

    @Override
    public CommonReaderWithSupplier<M> build() {
        return new CommonReaderWithSupplier<>(
                jooqReaderBuilder.isEmpty() ? null : jooqReaderBuilder.build(),
                jooqJsonReaderBuilder.isEmpty() ? null : jooqJsonReaderBuilder.build(),
                modelSupplier
        );
    }
}
