package ru.yandex.direct.jooqmapper.commonwrite;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.jsonwrite.JooqJsonWriter;
import ru.yandex.direct.jooqmapper.jsonwrite.JooqJsonWriterBuilder;
import ru.yandex.direct.jooqmapper.jsonwrite.JsonWriter1Builder;
import ru.yandex.direct.jooqmapper.write.DefaultWriterBuilder;
import ru.yandex.direct.jooqmapper.write.FunctionWriterBuilder;
import ru.yandex.direct.jooqmapper.write.JooqWriter;
import ru.yandex.direct.jooqmapper.write.JooqWriterBuilder;
import ru.yandex.direct.jooqmapper.write.SupplierWriterBuilder;
import ru.yandex.direct.jooqmapper.write.Writer1Builder;
import ru.yandex.direct.jooqmapper.write.Writer2Builder;
import ru.yandex.direct.jooqmapper.write.Writer3Builder;
import ru.yandex.direct.jooqmapper.write.WriterToFieldBuilder;
import ru.yandex.direct.model.Model;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class CommonWriterBuilder<M extends Model> {
    protected final JooqWriterBuilder<M> jooqWriterBuilder;
    protected final JooqJsonWriterBuilder<M> jooqJsonWriterBuilder;

    protected CommonWriterBuilder(
            @Nullable JooqWriter<? super M> jooqWriter
    ) {
        this.jooqWriterBuilder = jooqWriter != null ? JooqWriterBuilder.builder(jooqWriter) :
                JooqWriterBuilder.builder();
        this.jooqJsonWriterBuilder = JooqJsonWriterBuilder.builder();
    }

    protected CommonWriterBuilder(
            List<? extends JooqWriter<? super M>> jooqWriters,
            List<? extends JooqJsonWriter<? super M>> jooqJsonWriters
    ) {
        this.jooqWriterBuilder = JooqWriterBuilder.builder(jooqWriters);
        this.jooqJsonWriterBuilder = JooqJsonWriterBuilder.builder(jooqJsonWriters);
    }

    protected CommonWriterBuilder(
            @Nullable JooqWriterBuilder<M> jooqWriterBuilder
    ) {
        this.jooqWriterBuilder = jooqWriterBuilder != null ? jooqWriterBuilder : JooqWriterBuilder.builder();
        this.jooqJsonWriterBuilder = JooqJsonWriterBuilder.builder();
    }

    private CommonWriterBuilder() {
        this(JooqWriterBuilder.builder());
    }

    public static <M extends Model> CommonWriterBuilder<M> builder() {
        return new CommonWriterBuilder<>();
    }

    public static <M extends Model> CommonWriterBuilder<M> builder(JooqWriter<? super M> sourceMapper) {
        return new CommonWriterBuilder<>(sourceMapper);
    }

    public static <M extends Model> CommonWriterBuilder<M> builder(JooqWriterBuilder<M> jooqWriterBuilder) {
        return new CommonWriterBuilder<>(jooqWriterBuilder);
    }

    public static <M extends Model> CommonWriterBuilder<M> builder(CommonWriter<? super M> commonWriter) {
        return new CommonWriterBuilder<>(commonWriter.getJooqWriter());
    }

    public static <M extends Model> CommonWriterBuilder<M> builder(
            List<? extends CommonWriter<? super M>> commonWriters) {
        List<? extends JooqWriter<? super M>> jooqWriters = mapList(commonWriters, CommonWriter::getJooqWriter);
        List<? extends JooqJsonWriter<? super M>> jooqJsonWriters = mapList(commonWriters, CommonWriter::getJooqJsonWriter);

        return new CommonWriterBuilder<>(jooqWriters, jooqJsonWriters);
    }

    public <X extends Record, T, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            Writer1Builder<? super M, T, R> writer1Builder
    ) {
        jooqWriterBuilder.writeField(tableField, writer1Builder);
        return this;
    }

    public <X extends Record, T, R> CommonWriterBuilder<M> writeFieldExplicitly(
            TableField<X, R> tableField,
            Writer1Builder<? super M, T, R> writer1Builder
    ) {
        jooqWriterBuilder.writeFieldExplicitly(tableField, writer1Builder);
        return this;
    }

    public <X extends Record, T, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            WriterToFieldBuilder<? super M, T, R> writerToFieldBuilder
    ) {
        jooqWriterBuilder.writeField(tableField, writerToFieldBuilder);
        return this;
    }

    public <T> CommonWriterBuilder<M> writeField(
            TableField<?, T> tableField,
            Writer1Builder.Writer1WithPropertyStep<M, T> writer1Builder
    ) {
        jooqWriterBuilder.writeField(tableField, writer1Builder.by(t -> t));
        return this;
    }

    public <X extends Record, T1, T2, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            Writer2Builder<? super M, T1, T2, R> writer2Builder
    ) {
        jooqWriterBuilder.writeField(tableField, writer2Builder);
        return this;
    }

    public <X extends Record, T1, T2, T3, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            Writer3Builder<? super M, T1, T2, T3, R> writer3Builder
    ) {
        jooqWriterBuilder.writeField(tableField, writer3Builder);
        return this;
    }

    public <X extends Record, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            DefaultWriterBuilder<? super M, R> writer3Builder
    ) {
        jooqWriterBuilder.writeField(tableField, writer3Builder);
        return this;
    }

    public <X extends Record, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            SupplierWriterBuilder<? super M, R> supplierWriterBuilder
    ) {
        jooqWriterBuilder.writeField(tableField, supplierWriterBuilder);
        return this;
    }

    public <X extends Record, R> CommonWriterBuilder<M> writeField(
            TableField<X, R> tableField,
            FunctionWriterBuilder<? super M, R> functionWriterBuilder
    ) {
        jooqWriterBuilder.writeField(tableField, functionWriterBuilder);
        return this;
    }

    public <X extends Record, T> CommonWriterBuilder<M> writeField(
            TableField<X, String> tableField,
            JsonWriter1Builder<? super M, T> writer1Builder
    ) {
        jooqJsonWriterBuilder.writeField(tableField, writer1Builder);
        return this;
    }

    public CommonWriter<M> build() {
        return new CommonWriter<>(
                jooqWriterBuilder.isEmpty() ? null : jooqWriterBuilder.build(),
                jooqJsonWriterBuilder.isEmpty() ? null : jooqJsonWriterBuilder.build()
        );
    }

    public JooqWriterBuilder<M> getJooqWriterBuilder() {
        return jooqWriterBuilder;
    }

    public JooqJsonWriterBuilder<M> getJooqJsonWriterBuilder() {
        return jooqJsonWriterBuilder;
    }
}
