package ru.yandex.direct.jooqmapper.jsonread;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.jooqmapper.read.ReaderBuilders;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Билдер для создания {@link JooqJsonReader}. Используйте вместе с {@link ReaderBuilders}.
 */
public class JooqJsonReaderBuilder<M extends Model> {

    protected final Map<ModelProperty<? super M, ?>, JsonReader<?>> jsonReaders = new HashMap<>();

    protected JooqJsonReaderBuilder() {
    }

    public static <M extends Model> JooqJsonReaderBuilder<M> builder() {
        return new JooqJsonReaderBuilder<>();
    }

    public static <M extends Model> JooqJsonReaderBuilder<M> builder(
            JooqJsonReader<? super M> sourceMapper) {
        JooqJsonReaderBuilder<M> builder = new JooqJsonReaderBuilder<>();
        builder.jsonReaders.putAll(sourceMapper.getJsonReaders());
        return builder;
    }

    public static <M extends Model> JooqJsonReaderBuilder<M> builder(
            List<? extends JooqJsonReader<? super M>> sourceMapper) {
        JooqJsonReaderBuilder<M> builder = new JooqJsonReaderBuilder<>();
        sourceMapper.forEach(mapper -> builder.jsonReaders.putAll(getJsonReaders((mapper))));
        return builder;
    }

    private static <M extends Model> Map<? extends ModelProperty<? super M, ?>, ? extends JsonReader<?>> getJsonReaders(
            JooqJsonReader<? super M> sourceMapper) {
        return sourceMapper == null ? Map.of() : sourceMapper.getJsonReaders();
    }

    public <T> JooqJsonReaderBuilder<M> readJsonProperty(ModelProperty<? super M, T> modelProperty,
                                                         JsonReader1Builder<T> reader1Builder) {
        return putJsonReader(modelProperty, reader1Builder.build());
    }

    private <T> JooqJsonReaderBuilder<M> putJsonReader(ModelProperty<? super M, T> modelProperty,
                                                       JsonReader<T> reader) {
        jsonReaders.put(modelProperty, reader);
        return this;
    }

    public JooqJsonReader<M> build() {
        return new JooqJsonReader<>(jsonReaders);
    }

    public boolean isEmpty() {
        return jsonReaders.isEmpty();
    }
}
