package ru.yandex.direct.jooqmapper.jsonread;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.Field;
import org.jooq.Record;

/**
 * Читает значение из данных, выбранных из базы в виде {@link Record}.
 *
 * @param <T> тип читаемого значения.
 */
@ParametersAreNonnullByDefault
interface JsonReader<T> {
    Field<?> getRequiredDatabaseField();

    String getJsonPath();

    // JsonNode - уже нода со значением или null, если нет ноды
    T read(@Nullable JsonNode jsonNode);
}
