package ru.yandex.direct.jooqmapper.jsonread;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.Field;

import ru.yandex.direct.jooqmapper.read.ReaderFunction1;

import static java.util.Objects.requireNonNull;

/**
 * Простая реализация интерфейса {@link JsonReader}, читающая значение
 * свойства модели из одного поля ({@link Field}).
 *
 * @param <T> тип свойства модели, в которое осуществляется чтение из поля БД.
 */
@ParametersAreNonnullByDefault
public class JsonReader1<T> implements JsonReader<T> {

    private final Field<?> field;
    private final Function<JsonNode, T> readerFunction;
    private final String jsonPath;

    JsonReader1(Field<?> field, String jsonPath, ReaderFunction1<JsonNode, T> jsonNodeReaderFunction1) {
        this.field = requireNonNull(field, "field is required");
        this.jsonPath = requireNonNull(jsonPath, "reader function is required");
        requireNonNull(jsonNodeReaderFunction1, "reader function is required");
        this.readerFunction = jsonNodeReaderFunction1::read;
    }

    @Override
    public T read(JsonNode jsonNode) {
        return readerFunction.apply(jsonNode);
    }

    @Override
    public String getJsonPath() {
        return jsonPath;
    }

    @Override
    public final Field<?> getRequiredDatabaseField() {
        return field;
    }
}
