package ru.yandex.direct.jooqmapper.jsonread;

import com.fasterxml.jackson.databind.JsonNode;
import org.jooq.Field;

import ru.yandex.direct.jooqmapper.read.ReaderFunction1;

public class JsonReader1Builder<T> {

    private final JsonReader1WithFieldStep jsonReader1WithFieldStep;
    private final ReaderFunction1<JsonNode, T> readerFunction;

    private JsonReader1Builder(JsonReader1WithFieldStep jsonReader1WithFieldStep, ReaderFunction1<JsonNode, T> readerFunction) {
        this.jsonReader1WithFieldStep = jsonReader1WithFieldStep;
        this.readerFunction = readerFunction;
    }

    JsonReader1<T> build() {
        return new JsonReader1<>(jsonReader1WithFieldStep.field, jsonReader1WithFieldStep.jsonPath, readerFunction);
    }

    static JsonReader1WithFieldStep fromFieldAndPath(Field<String> field, String jsonPath) {
        return new JsonReader1WithFieldStep(field, jsonPath);
    }

    public static class JsonReader1WithFieldStep {
        private final Field<String> field;
        private final String jsonPath;

        private JsonReader1WithFieldStep(Field<String> field, String jsonPath) {
            this.field = field;
            this.jsonPath = jsonPath;
        }

        public <T> JsonReader1Builder<T> by(ReaderFunction1<JsonNode, T> readerFunction) {
            return new JsonReader1Builder<>(this, readerFunction);
        }
    }
}
