package ru.yandex.direct.jooqmapper.jsonwrite;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.jooqmapper.write.PropertyValues;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class DefaultJsonWriterBuilder<M extends Model> {

    private final DefaultJsonWriterWithPropertiesStep<M> jsonWriterWithPropertiesStep;
    private final Function<PropertyValues<M>, JsonNode> writerFunction;

    private DefaultJsonWriterBuilder(
            DefaultJsonWriterWithPropertiesStep<M> jsonWriterWithPropertiesStep,
            Function<PropertyValues<M>, JsonNode> writerFunction) {
        this.jsonWriterWithPropertiesStep = jsonWriterWithPropertiesStep;
        this.writerFunction = writerFunction;
    }

    DefaultJsonWriter<M> build() {
        return new DefaultJsonWriter<>(
                jsonWriterWithPropertiesStep.properties, jsonWriterWithPropertiesStep.jsonPath, writerFunction
        );
    }

    static <M extends Model> DefaultJsonWriterWithPropertiesStep<M> fromPropertiesAndPath(
            List<? extends ModelProperty<? super M, ?>> properties, String jsonPath) {
        return new DefaultJsonWriterWithPropertiesStep<>(new HashSet<>(properties), jsonPath);
    }

    static <M extends Model> DefaultJsonWriterWithPropertiesStep<M> fromPropertiesAndPath(
            Set<? extends ModelProperty<? super M, ?>> properties, String jsonPath) {
        return new DefaultJsonWriterWithPropertiesStep<>(properties, jsonPath);
    }

    public static class DefaultJsonWriterWithPropertiesStep<M extends Model> {
        private final ImmutableSet<ModelProperty<? super M, ?>> properties;
        private final String jsonPath;

        private DefaultJsonWriterWithPropertiesStep(Set<? extends ModelProperty<? super M, ?>> properties, String jsonPath) {
            this.properties = ImmutableSet.copyOf(properties);
            this.jsonPath = jsonPath;
        }

        public DefaultJsonWriterBuilder<M> by(Function<PropertyValues<M>, JsonNode> writerFunction) {
            return new DefaultJsonWriterBuilder<>(this, writerFunction);
        }
    }
}
