package ru.yandex.direct.jooqmapper.jsonwrite;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Вычисляет из модели записываемое в json значение.
 *
 * @param <M> тип модели.
 */
@ParametersAreNonnullByDefault
interface JsonWriter<M extends Model> {

    /**
     * @return список всех {@link ModelProperty}, читаемых из модели данным экземпляром.
     */
    Set<ModelProperty<? super M, ?>> getProperties();

    JsonNode write(M model);

    String getJsonPath();
}
