package ru.yandex.direct.jooqmapper.jsonwrite;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.direct.jooqmapper.write.WriterFunction1;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class JsonWriter1Builder<M extends Model, T> {

    private final JsonWriter1WithPropertyStep<M, T> writer1WithPropertyStep;
    private final WriterFunction1<T, JsonNode> writerFunction;

    private JsonWriter1Builder(
            JsonWriter1WithPropertyStep<M, T> writer1WithPropertyStep,
            WriterFunction1<T, JsonNode> writerFunction) {
        this.writer1WithPropertyStep = writer1WithPropertyStep;
        this.writerFunction = writerFunction;
    }

    static <M extends Model, T> JsonWriter1WithPropertyStep<M, T> fromProperty(
            ModelProperty<? super M, T> property,
            String jsonPath) {
        return new JsonWriter1WithPropertyStep<>(property, jsonPath);
    }

    JsonWriter1<M, T> build() {
        return new JsonWriter1<>(writer1WithPropertyStep.property, writer1WithPropertyStep.jsonPath, writerFunction);
    }

    public static class JsonWriter1WithPropertyStep<M extends Model, T> {
        private final ModelProperty<? super M, T> property;
        private final String jsonPath;

        private JsonWriter1WithPropertyStep(ModelProperty<? super M, T> property, String jsonPath) {
            this.property = property;
            this.jsonPath = jsonPath;
        }

        public JsonWriter1Builder<M, T> by(WriterFunction1<T, JsonNode> writerFunction) {
            return new JsonWriter1Builder<>(this, writerFunction);
        }
    }
}
