package ru.yandex.direct.jooqmapper.kotlinwrite

import com.google.common.base.Preconditions
import org.jooq.Record
import org.jooq.TableField
import ru.yandex.direct.jooqmapper.kotlinwrite.KotlinWriter1Builder.KotlinWriter1WithPropertyStep

/**
 * Билдер для создания [KotlinJooqWriter]. Используйте вместе с [KotlinWriterBuilders].
 */
class JooqKotlinWriterBuilder<DataClass> private constructor() {
    private val writers: MutableMap<TableField<out Record, *>, KotlinWriter<DataClass, *>> = mutableMapOf()

    fun <X : Record, T, R> writeField(
            tableField: TableField<X, R>,
            writer1Builder: KotlinWriter1Builder<DataClass, T, R>
    ): JooqKotlinWriterBuilder<DataClass> {
        return putWriter(tableField, writer1Builder.build())
    }

    fun <T> writeField(
        tableField: TableField<out Record, T>,
        writer1Builder: KotlinWriter1WithPropertyStep<DataClass, T>,
    ): JooqKotlinWriterBuilder<DataClass> {
        return putWriter(tableField, writer1Builder.by { it }.build())
    }

    private fun <T> putWriter(
        tableField: TableField<out Record, T>,
        writer: KotlinWriter<DataClass, T>,
    ): JooqKotlinWriterBuilder<DataClass> {
        Preconditions.checkArgument(!writers.containsKey(tableField),
                "attempt to register more than one writer for field %s", tableField)
        writers[tableField] = writer
        return this
    }

    fun build(): KotlinJooqWriter<DataClass> {
        return KotlinJooqWriter(writers)
    }

    val isEmpty: Boolean
        get() = writers.isEmpty()

    companion object {
        fun <DataClass> builder(): JooqKotlinWriterBuilder<DataClass> {
            return JooqKotlinWriterBuilder()
        }
    }
}
