package ru.yandex.direct.jooqmapper.kotlinwrite

import com.google.common.base.Preconditions.checkState
import one.util.streamex.EntryStream
import org.jooq.Record
import org.jooq.Table
import org.jooq.TableField
import ru.yandex.direct.model.KtModelChanges
import ru.yandex.direct.utils.Collectors

/**
 * @see ru.yandex.direct.jooqmapper.write.JooqWriter
 * менять совместно
 */
class KotlinJooqWriter<DataClass>(
    private val writers: MutableMap<TableField<out Record, *>, KotlinWriter<DataClass, *>>,
): KtModelToDbFieldValuesMapper<DataClass> {

    override fun <R : Record?> getDbFieldValues(
        model: DataClass,
        table: Table<R>,
    ): MutableMap<TableField<R, out Any?>, Any?> {
        return EntryStream.of(writers)
            .filterKeys { tableField -> tableField.table == table }
            .mapKeys { tableField -> tableField as TableField<R, *> }
            .mapValues { writer -> writer.write(model) }
            .collect(Collectors.nullFriendlyMapCollector())
    }

    override fun <R : Record> getDbFieldValues(
        ktModelChanges: KtModelChanges<out Any, DataClass>,
        table: Table<R>,
    ): MutableMap<TableField<R, out Any?>, Any?> {
        return EntryStream.of(writers)
            .filterKeys { tableField -> tableField.table == table }
            .mapKeys { tableField -> tableField as TableField<R, *> }
            .filterValues { writer -> writer.getProperties().any { ktModelChanges.isPresent(it) } }
            //если поменяли свойство, то должны были докинуть в KtModelChanges остальные влияющие на столбец
            .peekValues { writer -> checkState(
                writer.getProperties().all { ktModelChanges.isPresent(it) },
                "not all properties provided for writer with properties " +
                    writer.getProperties().map{ it.name }.joinToString (", ") +
                    " ; provided are " +
                    ktModelChanges.getChangedProps().keys.map{ it.name }.joinToString (", "),
            ) }
            .mapValues { writer -> writer.write(ktModelChanges) }
            .collect(Collectors.nullFriendlyMapCollector())
    }
}
