package ru.yandex.direct.jooqmapper.kotlinwrite;

import com.google.common.base.Preconditions.checkArgument
import ru.yandex.direct.model.KtModelChanges
import kotlin.reflect.KProperty1

/**
 * Предоставляет доступ к ограниченному набору свойств модели
 * См @see ru.yandex.direct.jooqmapper.write.PropertyValues
 */
class KotlinPropertyValues<DataClass> private constructor(
    private val properties: Map<KProperty1<DataClass, *>, *>,
) {
    init {
        checkArgument(!properties.isEmpty(), "allowed properties set must not be empty")
    }

    operator fun <T> get(property: KProperty1<DataClass, T>): T {
        checkArgument(properties.contains(property),
                "this property (%s) can not be requested through this PropertyValues instance, check initialization",
            property)
        return properties.get(property) as T
    }

    companion object {
        fun<DataClass> fromModel(model: DataClass, modelProps: Set<KProperty1<DataClass, Any?>>)=
            KotlinPropertyValues(modelProps.associateWith { it.get(model) })

        fun<DataClass> fromKtModelChanges(modelChanges: KtModelChanges<out Any, DataClass>) =
            KotlinPropertyValues(modelChanges.getChangedProps())
    }
}
