package ru.yandex.direct.jooqmapper.kotlinwrite

import com.google.common.base.Preconditions
import com.google.common.collect.ImmutableSet
import ru.yandex.direct.model.KtModelChanges
import java.util.function.Function
import kotlin.reflect.KProperty1

/**
 * См @see ru.yandex.direct.jooqmapper.write.Writer
 */
interface KotlinWriter<M, R> {
    /**
     * @return список всех [KProperty1], читаемых из модели данным экземпляром.
     */
    fun getProperties(): Set<KProperty1<M, *>>

    fun write(model: KotlinPropertyValues<M>): R

    fun write(model: M): R = write(KotlinPropertyValues.fromModel(model, getProperties()))

    fun write(modelChanges: KtModelChanges<out Any, M>): R = write(KotlinPropertyValues.fromKtModelChanges(modelChanges))
}

class KotlinDefaultWriter<M, R> internal constructor(
    properties: Set<KProperty1<M, Any?>>,
    private val writerFunction: Function<KotlinPropertyValues<M>, R>,
) : KotlinWriter<M, R> {
    private val properties: Set<KProperty1<M, Any?>>

    init {
        this.properties = ImmutableSet.copyOf(properties)
        Preconditions.checkArgument(!properties.isEmpty(), "properties set must not be empty")
    }

    override fun getProperties(): Set<KProperty1<M, Any?>> {
        return properties
    }

    override fun write(propertyValues: KotlinPropertyValues<M>): R {
        return writerFunction.apply(propertyValues)
    }
}
