package ru.yandex.direct.jooqmapper.kotlinwrite

import com.google.common.collect.ImmutableSet
import ru.yandex.direct.jooqmapper.write.WriterFunction1
import kotlin.reflect.KProperty1

/**
 * Простая реализация интерфейса [KotlinWriter], которая вычисляет
 * записываемое в базу значение из одного свойства модели.
 *
 * @param <M> тип модели.
 * @param <T> тип свойства модели.
 * @param <R> тип записываемого в базу значения.
 * @see ru.yandex.direct.jooqmapper.write.Writer1
</R></T></M> */
class KotlinWriter1<M, T, R> internal constructor(
    property: KProperty1<M, T>,
    writerFunction: WriterFunction1<T, R>
) : KotlinWriter<M, R> by KotlinDefaultWriter(
    ImmutableSet.of(property),
    { propertyValues: KotlinPropertyValues<M> -> writerFunction.write(propertyValues[property]) }
)

class KotlinWriter1Builder<M, T, R> private constructor(
    private val writer1WithPropertyStep: KotlinWriter1WithPropertyStep<M, T>,
    private val writerFunction: WriterFunction1<T, R>,
) {
    fun build(): KotlinWriter1<M, T, R> {
        return KotlinWriter1(writer1WithPropertyStep.property, writerFunction)
    }

    class KotlinWriter1WithPropertyStep<M, T> internal constructor(val property: KProperty1<M, T>) {
        internal fun <R> by(mapper: (T) -> R): KotlinWriter1Builder<M, T, R> {
            return KotlinWriter1Builder(this, mapper)
        }
    }

    companion object {
        internal fun <M, T> fromKProperty1(property: KProperty1<M, T>) = KotlinWriter1WithPropertyStep(property)

        internal fun <M, T, R> fromKProperty1(property: KProperty1<M, T>, mapper: (T) -> R) =
            KotlinWriter1WithPropertyStep(property).by(mapper)
    }
}
