package ru.yandex.direct.jooqmapper.read;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

import com.google.common.collect.ImmutableSet;
import org.jooq.Field;

public class DefaultReaderBuilder<T> {

    private final ImmutableSet<Field<?>> fields;
    private final Function<FieldValues, T> readerFunction;

    private DefaultReaderBuilder(ImmutableSet<Field<?>> fields,
                                 Function<FieldValues, T> readerFunction) {
        this.fields = fields;
        this.readerFunction = readerFunction;
    }

    DefaultReader<T> build() {
        return new DefaultReader<>(fields, readerFunction);
    }

    static DefaultReaderWithFieldsStep fromFields(List<Field<?>> fields) {
        return new DefaultReaderWithFieldsStep(new HashSet<>(fields));
    }

    static DefaultReaderWithFieldsStep fromFields(Set<Field<?>> fields) {
        return new DefaultReaderWithFieldsStep(fields);
    }

    public static class DefaultReaderWithFieldsStep {
        private final ImmutableSet<Field<?>> fields;

        private DefaultReaderWithFieldsStep(Set<Field<?>> fields) {
            this.fields = ImmutableSet.copyOf(fields);
        }

        public <T> DefaultReaderBuilder<T> by(Function<FieldValues, T> readerFunction) {
            return new DefaultReaderBuilder<>(fields, readerFunction);
        }
    }
}
