package ru.yandex.direct.jooqmapper.read;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.jooq.Field;
import org.jooq.Record;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

/**
 * Предоставляет доступ к ограниченному набору данных, находящихся в {@link Record}.
 */
@ParametersAreNonnullByDefault
public class FieldValues {

    private final ImmutableSet<Field<?>> allowedFields;
    private final Record record;

    FieldValues(Set<Field<?>> allowedFields, Record record) {
        this.allowedFields = ImmutableSet.copyOf(requireNonNull(allowedFields, "allowed fields is required"));
        this.record = requireNonNull(record, "record is required");
    }

    public <T> T getValue(Field<T> field) {
        checkArgument(allowedFields.contains(field),
                "this field (%s) can not be requested through this FieldValues instance, check initialization", field);
        return record.get(field);
    }
}
