package ru.yandex.direct.jooqmapper.read;

import java.util.function.Supplier;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Objects.requireNonNull;

/**
 * Билдер для создания {@link JooqReaderWithSupplier}. Используйте вместе с {@link ReaderBuilders}.
 */
public class JooqReaderWithSupplierBuilder<M extends Model> extends JooqReaderBuilder<M> {

    private final Supplier<M> modelSupplier;

    private JooqReaderWithSupplierBuilder(Supplier<M> modelSupplier) {
        this.modelSupplier = requireNonNull(modelSupplier, "model supplier is required");
    }

    public static <M extends Model> JooqReaderWithSupplierBuilder<M> builder(
            JooqReader<? super M> sourceMapper, Supplier<M> modelSupplier) {
        JooqReaderWithSupplierBuilder<M> builder =
                new JooqReaderWithSupplierBuilder<>(modelSupplier);
        builder.readers.putAll(sourceMapper.getReaders());
        builder.fieldsForFirst.addAll(sourceMapper.getFieldsForFirstToRead());
        return builder;
    }

    public static <M extends Model> JooqReaderWithSupplierBuilder<M> builder(Supplier<M> modelSupplier) {
        return new JooqReaderWithSupplierBuilder<>(modelSupplier);
    }

    @Override
    public <T extends Model> JooqReaderWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            JooqReaderWithSupplier<T> reader
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readProperty(modelProperty, reader);
    }

    @Override
    public <T, R> JooqReaderWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader1Builder<R, T> reader1Builder
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readProperty(modelProperty, reader1Builder);
    }

    @Override
    public <T> JooqReaderWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader1Builder.Reader1WithFieldStep<T> reader1Builder
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readProperty(modelProperty, reader1Builder);
    }

    @Override
    public <T, R1, R2> JooqReaderWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader2Builder<R1, R2, T> reader2Builder
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readProperty(modelProperty, reader2Builder);
    }

    @Override
    public <T, R1, R2, R3> JooqReaderWithSupplierBuilder<M> readProperty(
            ModelProperty<? super M, T> modelProperty,
            Reader3Builder<R1, R2, R3, T> reader3Builder) {
        return (JooqReaderWithSupplierBuilder<M>) super.readProperty(modelProperty, reader3Builder);
    }

    @Override
    public <T> JooqReaderWithSupplierBuilder<M> readProperty(ModelProperty<? super M, T> modelProperty,
                                                             DefaultReaderBuilder<T> readerBuilder) {
        return (JooqReaderWithSupplierBuilder<M>) super.readProperty(modelProperty, readerBuilder);
    }

    @Override
    public <T, R> JooqReaderWithSupplierBuilder<M> readPropertyForFirst(
            ModelProperty<? super M, T> modelProperty,
            Reader1Builder<R, T> reader1Builder
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readPropertyForFirst(modelProperty, reader1Builder);
    }

    @Override
    public <T> JooqReaderWithSupplierBuilder<M> readPropertyForFirst(
            ModelProperty<? super M, T> modelProperty,
            Reader1Builder.Reader1WithFieldStep<T> reader1Builder
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readPropertyForFirst(modelProperty, reader1Builder);
    }

    @Override
    public <T, R1, R2> JooqReaderWithSupplierBuilder<M> readPropertyForFirst(
            ModelProperty<? super M, T> modelProperty,
            Reader2Builder<R1, R2, T> reader2Builder
    ) {
        return (JooqReaderWithSupplierBuilder<M>) super.readPropertyForFirst(modelProperty, reader2Builder);
    }

    @Override
    public <T, R1, R2, R3> JooqReaderWithSupplierBuilder<M> readPropertyForFirst(
            ModelProperty<? super M, T> modelProperty,
            Reader3Builder<R1, R2, R3, T> reader3Builder) {
        return (JooqReaderWithSupplierBuilder<M>) super.readPropertyForFirst(modelProperty, reader3Builder);
    }

    @Override
    public <T> JooqReaderWithSupplierBuilder<M> readPropertyForFirst(ModelProperty<? super M, T> modelProperty,
                                                                     DefaultReaderBuilder<T> readerBuilder) {
        return (JooqReaderWithSupplierBuilder<M>) super.readPropertyForFirst(modelProperty, readerBuilder);
    }

    @Override
    public JooqReaderWithSupplier<M> build() {
        return new JooqReaderWithSupplier<>(readers, fieldsForFirst, modelSupplier);
    }
}
