package ru.yandex.direct.jooqmapper.read;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;

/**
 * Читает значение из данных, выбранных из базы в виде {@link Record}.
 *
 * @param <T> тип читаемого значения.
 */
@ParametersAreNonnullByDefault
interface Reader<T> {

    /**
     * @return все поля, читаемые из {@link Record} данным экземпляром.
     */
    Set<Field<?>> getRequiredDatabaseFields();

    T read(Record record);
}
