package ru.yandex.direct.jooqmapper.read;

import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.jooq.Field;
import org.jooq.Record;

import static java.util.Objects.requireNonNull;

/**
 * Простая реализация интерфейса {@link Reader}, читающая значение
 * свойства модели из одного поля ({@link Field}).
 *
 * @param <R> тип прочитанного из базы значения.
 * @param <T> тип свойства модели, в которое осуществляется чтение из поля БД.
 * @see DefaultReader
 */
@ParametersAreNonnullByDefault
public class Reader1<R, T> implements Reader<T> {

    private final DefaultReader<T> innerReader;

    Reader1(Field<R> field, ReaderFunction1<R, T> readerFunction) {
        requireNonNull(field, "field is required");
        requireNonNull(readerFunction, "reader function is required");

        Function<FieldValues, T> innerReaderFunction =
                fieldValues -> readerFunction.read(fieldValues.getValue(field));

        Set<Field<?>> fields = ImmutableSet.of(field);
        this.innerReader = new DefaultReader<>(fields, innerReaderFunction);
    }

    @Override
    public final Set<Field<?>> getRequiredDatabaseFields() {
        return innerReader.getRequiredDatabaseFields();
    }

    @Override
    public final T read(Record record) {
        return innerReader.read(record);
    }
}
