package ru.yandex.direct.jooqmapper.read;

import java.util.function.Function;

import org.jooq.Field;

public class Reader1Builder<R, T> {

    private final Reader1WithFieldStep<R> reader1WithFieldStep;
    private final ReaderFunction1<R, T> readerFunction;

    private Reader1Builder(Reader1WithFieldStep<R> reader1WithFieldStep, ReaderFunction1<R, T> readerFunction) {
        this.reader1WithFieldStep = reader1WithFieldStep;
        this.readerFunction = readerFunction;
    }

    Reader1<R, T> build() {
        return new Reader1<>(reader1WithFieldStep.field, readerFunction);
    }

    static <R> Reader1WithFieldStep<R> fromField(Field<R> field) {
        return new Reader1WithFieldStep<>(field);
    }

    public static class Reader1WithFieldStep<R> {
        private final Field<R> field;

        private Reader1WithFieldStep(Field<R> field) {
            this.field = field;
        }

        public <T> Reader1Builder<R, T> by(ReaderFunction1<R, T> readerFunction) {
            return new Reader1Builder<>(this, readerFunction);
        }
    }

    public <S> Reader1Builder<R, S> andThen(Function<T, S> after) {
        return new Reader1Builder<>(this.reader1WithFieldStep, value -> after.apply(readerFunction.read(value)));
    }
}
