package ru.yandex.direct.jooqmapper.read;

import org.jooq.Field;

public class Reader2Builder<R1, R2, T> {

    private final Reader2WithFieldsStep<R1, R2> reader2WithFieldsStep;
    private final ReaderFunction2<R1, R2, T> readerFunction;

    private Reader2Builder(Reader2WithFieldsStep<R1, R2> reader2WithFieldsStep,
                           ReaderFunction2<R1, R2, T> readerFunction) {
        this.reader2WithFieldsStep = reader2WithFieldsStep;
        this.readerFunction = readerFunction;
    }

    Reader2<R1, R2, T> build() {
        return new Reader2<>(reader2WithFieldsStep.field1, reader2WithFieldsStep.field2, readerFunction);
    }

    static <R1, R2> Reader2WithFieldsStep<R1, R2> fromFields(Field<R1> field1, Field<R2> field2) {
        return new Reader2WithFieldsStep<>(field1, field2);
    }

    public static class Reader2WithFieldsStep<R1, R2> {
        private final Field<R1> field1;
        private final Field<R2> field2;

        private Reader2WithFieldsStep(Field<R1> field1, Field<R2> field2) {
            this.field1 = field1;
            this.field2 = field2;
        }

        public <T> Reader2Builder<R1, R2, T> by(ReaderFunction2<R1, R2, T> readerFunction) {
            return new Reader2Builder<>(this, readerFunction);
        }
    }
}
