package ru.yandex.direct.jooqmapper.read;

import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.jooq.Field;
import org.jooq.Record;

import static java.util.Objects.requireNonNull;

/**
 * @see DefaultReader
 * @see Reader1
 * @see Reader2
 */
@ParametersAreNonnullByDefault
public class Reader3<R1, R2, R3, T> implements Reader<T> {

    private final DefaultReader<T> innerReader;

    public Reader3(Field<R1> field1, Field<R2> field2, Field<R3> field3,
                   ReaderFunction3<R1, R2, R3, T> readerFunction) {
        requireNonNull(field1, "first field is required");
        requireNonNull(field2, "second field is required");
        requireNonNull(field3, "third field is required");
        requireNonNull(readerFunction, "reader function is required");

        Function<FieldValues, T> innerReaderFunction =
                fieldValues -> readerFunction.read(fieldValues.getValue(field1),
                        fieldValues.getValue(field2), fieldValues.getValue(field3));

        Set<Field<?>> fields = ImmutableSet.of(field1, field2, field3);
        this.innerReader = new DefaultReader<>(fields, innerReaderFunction);
    }

    @Override
    public final Set<Field<?>> getRequiredDatabaseFields() {
        return innerReader.getRequiredDatabaseFields();
    }

    @Override
    public final T read(Record record) {
        return innerReader.read(record);
    }
}
