package ru.yandex.direct.jooqmapper.read;

import org.jooq.Field;

public class Reader3Builder<R1, R2, R3, T> {

    private final Reader3WithFieldsStep<R1, R2, R3> reader3WithFieldsStep;
    private final ReaderFunction3<R1, R2, R3, T> readerFunction;

    private Reader3Builder(Reader3WithFieldsStep<R1, R2, R3> reader3WithFieldsStep,
                           ReaderFunction3<R1, R2, R3, T> readerFunction) {
        this.reader3WithFieldsStep = reader3WithFieldsStep;
        this.readerFunction = readerFunction;
    }

    Reader3<R1, R2, R3, T> build() {
        return new Reader3<>(reader3WithFieldsStep.field1, reader3WithFieldsStep.field2,
                reader3WithFieldsStep.field3, readerFunction);
    }

    static <R1, R2, R3> Reader3WithFieldsStep<R1, R2, R3> fromFields(
            Field<R1> field1, Field<R2> field2, Field<R3> field3) {
        return new Reader3WithFieldsStep<>(field1, field2, field3);
    }

    public static class Reader3WithFieldsStep<R1, R2, R3> {
        private final Field<R1> field1;
        private final Field<R2> field2;
        private final Field<R3> field3;

        private Reader3WithFieldsStep(Field<R1> field1, Field<R2> field2, Field<R3> field3) {
            this.field1 = field1;
            this.field2 = field2;
            this.field3 = field3;
        }

        public <T> Reader3Builder<R1, R2, R3, T> by(ReaderFunction3<R1, R2, R3, T> readerFunction) {
            return new Reader3Builder<>(this, readerFunction);
        }
    }
}
