package ru.yandex.direct.jooqmapper.read;

import java.util.List;
import java.util.Set;
import java.util.function.Function;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Field;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;

/**
 * Для построения {@link JooqReader} используйте {@link JooqReaderBuilder},
 * а для построения {@link JooqMapper} - {@link JooqMapperBuilder}.
 */
public final class ReaderBuilders {

    private ReaderBuilders() {
    }

    public static <R> Reader1Builder.Reader1WithFieldStep<R> fromField(Field<R> field) {
        return Reader1Builder.fromField(field);
    }

    public static <R1, R2> Reader2Builder.Reader2WithFieldsStep<R1, R2> fromFields(
            Field<R1> field1, Field<R2> field2) {
        return Reader2Builder.fromFields(field1, field2);
    }

    public static <R1, R2, R3> Reader3Builder.Reader3WithFieldsStep<R1, R2, R3> fromFields(
            Field<R1> field1, Field<R2> field2, Field<R3> field3) {
        return Reader3Builder.fromFields(field1, field2, field3);
    }

    public static DefaultReaderBuilder.DefaultReaderWithFieldsStep fromFields(List<Field<?>> fields) {
        return DefaultReaderBuilder.fromFields(fields);
    }

    public static DefaultReaderBuilder.DefaultReaderWithFieldsStep fromFields(Set<Field<?>> fields) {
        return DefaultReaderBuilder.fromFields(fields);
    }

    /**
     * Получает boolean значение, которое говорит, есть ли в записи в поле setField SQL'ного типа
     * Set(jooq конвертит в String)
     */
    public static Reader1Builder<String, Boolean> fromSet(Field<String> setField, String flagName) {
        return fromField(setField).by(setString -> setString != null && StreamEx.split(setString, ",")
                .map(String::trim)
                .anyMatch(str -> str.equals(flagName)));
    }

    /**
     * Получает Set<Enum<T>> из поля setField SQL'ного типа
     * Set(jooq конвертит в String)
     */
    public static <T extends Enum<T>> Reader1Builder<String, Set<T>> fromSet(Field<String> setField,
                                                                             Class<T> enumCls) {
        return fromSet(setField, value -> Enum.valueOf(enumCls, value.toUpperCase()));
    }

    /**
     * Получает Set<Enum<T>> из поля setField SQL'ного типа
     * Set(jooq конвертит в String)
     */
    public static <T extends Enum<T>> Reader1Builder<String, Set<T>> fromSet(Field<String> setField,
                                                                             Function<String, T> enumMapper) {
        return fromField(setField).by(setString -> StreamEx.split(setString, ",")
                .map(String::trim)
                .remove(StringUtils::isEmpty)
                .map(enumMapper)
                .toSet());
    }
}
