package ru.yandex.direct.jooqmapper.write;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class DefaultWriterBuilder<M extends Model, R> {

    private final ImmutableSet<ModelProperty<? super M, ?>> properties;
    private final Function<PropertyValues<M>, R> writerFunction;

    private DefaultWriterBuilder(
            ImmutableSet<ModelProperty<? super M, ?>> properties,
            Function<PropertyValues<M>, R> writerFunction) {
        this.properties = properties;
        this.writerFunction = writerFunction;
    }

    DefaultWriter<M, R> build() {
        return new DefaultWriter<>(properties, writerFunction);
    }

    static <M extends Model> DefaultWriterWithPropertiesStep<M> fromProperties(
            List<? extends ModelProperty<? super M, ?>> properties) {
        return new DefaultWriterWithPropertiesStep<>(new HashSet<>(properties));
    }

    static <M extends Model> DefaultWriterWithPropertiesStep<M> fromProperties(
            Set<? extends ModelProperty<? super M, ?>> properties) {
        return new DefaultWriterWithPropertiesStep<>(properties);
    }

    public static class DefaultWriterWithPropertiesStep<M extends Model> {
        private final ImmutableSet<ModelProperty<? super M, ?>> properties;

        private DefaultWriterWithPropertiesStep(Set<? extends ModelProperty<? super M, ?>> properties) {
            this.properties = ImmutableSet.copyOf(properties);
        }

        public <R> DefaultWriterBuilder<M, R> by(Function<PropertyValues<M>, R> writerFunction) {
            return new DefaultWriterBuilder<>(properties, writerFunction);
        }
    }
}
