package ru.yandex.direct.jooqmapper.write;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Objects.requireNonNull;

@ParametersAreNonnullByDefault
public class FunctionWriter<M extends Model, R> implements Writer<M, R> {
    private final Function<M, R> function;

    public FunctionWriter(Function<M, R> function) {
        requireNonNull(function, "function is required");
        this.function = function;
    }

    @Override
    public Set<ModelProperty<? super M, ?>> getProperties() {
        return Collections.emptySet();
    }

    @Override
    public R write(M model) {
        return function.apply(model);
    }
}
