package ru.yandex.direct.jooqmapper.write;

import java.util.function.Function;

import ru.yandex.direct.model.Model;

public class FunctionWriterBuilder<M extends Model, T> {
    private final Function<M, T> function;

    private FunctionWriterBuilder(Function<M, T> function) {
        this.function = function;
    }

    static <M extends Model, T> FunctionWriterBuilder<M, T> fromFunction(Function<M, T> function) {
        return new FunctionWriterBuilder<>(function);
    }

    FunctionWriter<M, T> build() {
        return new FunctionWriter<>(function);
    }
}
