package ru.yandex.direct.jooqmapper.write;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

/**
 * Предоставляет доступ к ограниченному набору свойств ({@link ModelProperty}) модели ({@link Model}).
 *
 * @param <M> тип модели.
 */
@ParametersAreNonnullByDefault
public class PropertyValues<M extends Model> {

    private final Set<ModelProperty<? super M, ?>> allowedProperties;
    private final M model;

    public PropertyValues(Set<ModelProperty<? super M, ?>> allowedProperties, M model) {
        this.allowedProperties = requireNonNull(allowedProperties, "allowed properties set is required");
        this.model = requireNonNull(model, "model instance is required");
        checkArgument(!allowedProperties.isEmpty(), "allowed properties set must not be empty");
    }

    public <T> T get(ModelProperty<? super M, T> modelProperty) {
        checkArgument(allowedProperties.contains(modelProperty),
                "this property (%s) can not be requested through this PropertyValues instance, check initialization",
                modelProperty);
        return modelProperty.get(model);
    }
}
