package ru.yandex.direct.jooqmapper.write;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Objects.requireNonNull;

/**
 * Записываемое в базу значение берется из заданного supplier'а
 *
 * @param <M> тип модели.
 * @param <R> тип записываемого в базу значения.
 */
@ParametersAreNonnullByDefault
public class SupplierWriter<M extends Model, R> implements Writer<M, R> {
    private final Supplier<R> supplier;

    public SupplierWriter(Supplier<R> supplier) {
        requireNonNull(supplier, "supplier is required");
        this.supplier = supplier;
    }

    @Override
    public Set<ModelProperty<? super M, ?>> getProperties() {
        return Collections.emptySet();
    }

    @Override
    public R write(M model) {
        return supplier.get();
    }
}
