package ru.yandex.direct.jooqmapper.write;

import java.util.function.Supplier;

import ru.yandex.direct.model.Model;

public class SupplierWriterBuilder<M extends Model, T> {
    private final Supplier<T> supplier;

    private SupplierWriterBuilder(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    static <M extends Model, T> SupplierWriterBuilder<M, T> fromSupplier(Supplier<T> supplier) {
        return new SupplierWriterBuilder<>(supplier);
    }

    SupplierWriter<M, T> build() {
        return new SupplierWriter<>(supplier);
    }
}
