package ru.yandex.direct.jooqmapper.write;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Вычисляет из модели записываемое в базу значение.
 *
 * @param <M> тип модели.
 * @param <R> тип записываемого значения.
 */
@ParametersAreNonnullByDefault
interface Writer<M extends Model, R> {

    /**
     * @return список всех {@link ModelProperty}, читаемых из модели данным экземпляром.
     */
    Set<ModelProperty<? super M, ?>> getProperties();

    R write(M model);
}
