package ru.yandex.direct.jooqmapper.write;

import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Objects.requireNonNull;

/**
 * Простая реализация интерфейса {@link Writer}, которая вычисляет
 * записываемое в базу значение из одного свойства модели ({@link ModelProperty}).
 *
 * @param <M> тип модели.
 * @param <T> тип свойства модели.
 * @param <R> тип записываемого в базу значения.
 * @see DefaultWriter
 */
@ParametersAreNonnullByDefault
public class Writer1<M extends Model, T, R> implements Writer<M, R> {

    private final DefaultWriter<M, R> innerWriter;

    Writer1(ModelProperty<? super M, T> property,
            WriterFunction1<T, R> writerFunction) {
        requireNonNull(property, "model property is required");
        requireNonNull(writerFunction, "writer function is required");

        Function<PropertyValues<M>, R> innerWriterFunction =
                propertyValues -> writerFunction.write(propertyValues.get(property));

        Set<ModelProperty<? super M, ?>> properties = ImmutableSet.of(property);
        innerWriter = new DefaultWriter<>(properties, innerWriterFunction);
    }

    @Override
    public Set<ModelProperty<? super M, ?>> getProperties() {
        return innerWriter.getProperties();
    }

    @Override
    public R write(M model) {
        return innerWriter.write(model);
    }
}
