package ru.yandex.direct.jooqmapper.write;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class Writer1Builder<M extends Model, T, R> {

    private final Writer1WithPropertyStep<M, T> writer1WithPropertyStep;
    private final WriterFunction1<T, R> writerFunction;

    private Writer1Builder(
            Writer1WithPropertyStep<M, T> writer1WithPropertyStep,
            WriterFunction1<T, R> writerFunction) {
        this.writer1WithPropertyStep = writer1WithPropertyStep;
        this.writerFunction = writerFunction;
    }

    static <M extends Model, T> Writer1WithPropertyStep<M, T> fromProperty(
            ModelProperty<? super M, T> property) {
        return new Writer1WithPropertyStep<>(property);
    }

    Writer1<M, T, R> build() {
        return new Writer1<>(writer1WithPropertyStep.property, writerFunction);
    }

    public static class Writer1WithPropertyStep<M extends Model, T> {
        private final ModelProperty<? super M, T> property;

        private Writer1WithPropertyStep(ModelProperty<? super M, T> property) {
            this.property = property;
        }

        public <R> Writer1Builder<M, T, R> by(WriterFunction1<T, R> writerFunction) {
            return new Writer1Builder<>(this, writerFunction);
        }
    }
}
