package ru.yandex.direct.jooqmapper.write;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class Writer2Builder<M extends Model, T1, T2, R> {

    private final Writer2WithPropertiesStep<M, T1, T2> writer2WithPropertiesStep;
    private final WriterFunction2<T1, T2, R> writerFunction;

    private Writer2Builder(
            Writer2WithPropertiesStep<M, T1, T2> writer2WithPropertiesStep,
            WriterFunction2<T1, T2, R> writerFunction) {
        this.writer2WithPropertiesStep = writer2WithPropertiesStep;
        this.writerFunction = writerFunction;
    }

    static <M extends Model, T1, T2> Writer2WithPropertiesStep<M, T1, T2> fromProperties(
            ModelProperty<? super M, T1> property1,
            ModelProperty<? super M, T2> property2) {
        return new Writer2WithPropertiesStep<>(property1, property2);
    }

    Writer2<M, T1, T2, R> build() {
        return new Writer2<>(writer2WithPropertiesStep.property1,
                writer2WithPropertiesStep.property2, writerFunction);
    }

    public static class Writer2WithPropertiesStep<M extends Model, T1, T2> {
        private final ModelProperty<? super M, T1> property1;
        private final ModelProperty<? super M, T2> property2;

        private Writer2WithPropertiesStep(ModelProperty<? super M, T1> property1,
                                          ModelProperty<? super M, T2> property2) {
            this.property1 = property1;
            this.property2 = property2;
        }

        public <R> Writer2Builder<M, T1, T2, R> by(WriterFunction2<T1, T2, R> writerFunction) {
            return new Writer2Builder<>(this, writerFunction);
        }
    }
}
