package ru.yandex.direct.jooqmapper.write;

import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Objects.requireNonNull;

/**
 * @see DefaultWriter
 * @see Writer1
 * @see Writer2
 */
@ParametersAreNonnullByDefault
public class Writer3<M extends Model, T1, T2, T3, R> implements Writer<M, R> {

    private final DefaultWriter<M, R> innerWriter;

    Writer3(ModelProperty<? super M, T1> property1,
            ModelProperty<? super M, T2> property2,
            ModelProperty<? super M, T3> property3,
            WriterFunction3<T1, T2, T3, R> writerFunction) {
        requireNonNull(property1, "first model property is required");
        requireNonNull(property2, "second model property is required");
        requireNonNull(property3, "third model property is required");
        requireNonNull(writerFunction, "writer function is required");

        Function<PropertyValues<M>, R> innerWriterFunction =
                propertyValues -> writerFunction.write(propertyValues.get(property1),
                        propertyValues.get(property2), propertyValues.get(property3));

        Set<ModelProperty<? super M, ?>> properties =
                ImmutableSet.<ModelProperty<? super M, ?>>of(property1, property2, property3);
        innerWriter = new DefaultWriter<>(properties, innerWriterFunction);
    }

    @Override
    public Set<ModelProperty<? super M, ?>> getProperties() {
        return innerWriter.getProperties();
    }

    @Override
    public R write(M model) {
        return innerWriter.write(model);
    }
}
