package ru.yandex.direct.jooqmapper.write;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class Writer3Builder<M extends Model, T1, T2, T3, R> {

    private final Writer3WithPropertiesStep<M, T1, T2, T3> writer3WithPropertiesStep;
    private final WriterFunction3<T1, T2, T3, R> writerFunction;

    private Writer3Builder(
            Writer3WithPropertiesStep<M, T1, T2, T3> writer3WithPropertiesStep,
            WriterFunction3<T1, T2, T3, R> writerFunction) {
        this.writer3WithPropertiesStep = writer3WithPropertiesStep;
        this.writerFunction = writerFunction;
    }

    static <M extends Model, T1, T2, T3> Writer3WithPropertiesStep<M, T1, T2, T3> fromProperties(
            ModelProperty<? super M, T1> property1,
            ModelProperty<? super M, T2> property2,
            ModelProperty<? super M, T3> property3) {
        return new Writer3WithPropertiesStep<>(property1, property2, property3);
    }

    Writer3<M, T1, T2, T3, R> build() {
        return new Writer3<>(writer3WithPropertiesStep.property1,
                writer3WithPropertiesStep.property2,
                writer3WithPropertiesStep.property3, writerFunction);
    }

    public static class Writer3WithPropertiesStep<M extends Model, T1, T2, T3> {
        private final ModelProperty<? super M, T1> property1;
        private final ModelProperty<? super M, T2> property2;
        private final ModelProperty<? super M, T3> property3;

        private Writer3WithPropertiesStep(ModelProperty<? super M, T1> property1,
                                          ModelProperty<? super M, T2> property2,
                                          ModelProperty<? super M, T3> property3) {
            this.property1 = property1;
            this.property2 = property2;
            this.property3 = property3;
        }

        public <R> Writer3Builder<M, T1, T2, T3, R> by(WriterFunction3<T1, T2, T3, R> writerFunction) {
            return new Writer3Builder<>(this, writerFunction);
        }
    }
}
