package ru.yandex.direct.jooqmapper.write;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * Для построения {@link JooqWriter} используйте {@link JooqWriterBuilder},
 * а для построения {@link JooqMapper} - {@link JooqMapperBuilder}.
 */
public final class WriterBuilders {

    private WriterBuilders() {
    }

    public static <M extends Model, T> Writer1Builder.Writer1WithPropertyStep<M, T> fromProperty(
            ModelProperty<? super M, T> property) {
        return Writer1Builder.fromProperty(property);
    }

    public static <M extends Model, T1, T2> Writer2Builder.Writer2WithPropertiesStep<M, T1, T2> fromProperties(
            ModelProperty<? super M, T1> property1,
            ModelProperty<? super M, T2> property2) {
        return Writer2Builder.fromProperties(property1, property2);
    }

    public static <M extends Model, T1, T2, T3> Writer3Builder.Writer3WithPropertiesStep<M, T1, T2, T3> fromProperties(
            ModelProperty<? super M, T1> property1,
            ModelProperty<? super M, T2> property2,
            ModelProperty<? super M, T3> property3) {
        return Writer3Builder.fromProperties(property1, property2, property3);
    }

    public static <M extends Model> DefaultWriterBuilder.DefaultWriterWithPropertiesStep<M> fromProperties(
            @SuppressWarnings("unused") Class<M> modelClass,
            List<? extends ModelProperty<? super M, ?>> properties) {
        return DefaultWriterBuilder.fromProperties(properties);
    }

    public static <M extends Model> DefaultWriterBuilder.DefaultWriterWithPropertiesStep<M> fromProperties(
            @SuppressWarnings("unused") Class<M> modelClass,
            Set<? extends ModelProperty<? super M, ?>> properties) {
        return DefaultWriterBuilder.fromProperties(properties);
    }

    public static <M extends Model, T>
    WriterToFieldBuilder.WriterToFieldBuilderWithPropertyStep<? super M, T> fromPropertyToField(
            ModelProperty<? super M, T> property
    ) {
        return WriterToFieldBuilder.fromProperty(property);
    }

    public static <M extends Model, T> SupplierWriterBuilder<M, T> fromSupplier(Supplier<T> supplier) {
        return SupplierWriterBuilder.fromSupplier(supplier);
    }

    public static <M extends Model, T> FunctionWriterBuilder<M, T> fromFunction(Function<M, T> function) {
        return FunctionWriterBuilder.fromFunction(function);
    }
}
