package ru.yandex.direct.jooqmapper.write;

import org.jooq.Field;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Collections.singleton;

public class WriterToFieldBuilder<M extends Model, T, R> {

    private final WriterToFieldBuilderWithPropertyStep<M, T> writerToFieldWithPropertyStep;
    private final WriterFunction1<T, Field<R>> writerFunction;

    WriterToFieldBuilder(
            WriterToFieldBuilderWithPropertyStep<M, T> writerToFieldWithPropertyStep,
            WriterFunction1<T, Field<R>> writerFunction) {
        this.writerToFieldWithPropertyStep = writerToFieldWithPropertyStep;
        this.writerFunction = writerFunction;
    }

    DefaultWriter<M, Field<R>> build() {
        return new DefaultWriter<>(singleton(writerToFieldWithPropertyStep.property),
                propertyValues -> writerFunction.write(propertyValues.get(writerToFieldWithPropertyStep.property)));
    }

    static <M extends Model, T> WriterToFieldBuilderWithPropertyStep<M, T> fromProperty(
            ModelProperty<? super M, T> property) {
        return new WriterToFieldBuilderWithPropertyStep<>(property);
    }

    public static class WriterToFieldBuilderWithPropertyStep<M extends Model, T> {
        private final ModelProperty<? super M, T> property;

        private WriterToFieldBuilderWithPropertyStep(ModelProperty<? super M, T> property) {
            this.property = property;
        }

        public <R> WriterToFieldBuilder<M, T, R> by(WriterFunction1<T, Field<R>> writerFunction) {
            return new WriterToFieldBuilder<>(this, writerFunction);
        }
    }
}
