package ru.yandex.direct.jooqmapperhelper;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;

@ParametersAreNonnullByDefault
public class InsertHelperAggregator {
    private final DSLContext context;
    private final Map<Table<? extends Record>, InsertHelper<? extends Record>> insertHelperByTable;

    public InsertHelperAggregator(DSLContext context) {
        this.context = context;
        this.insertHelperByTable = new HashMap<>();
    }

    @SuppressWarnings("unchecked")
    public <R extends Record> InsertHelper<R> getOrCreate(Table<R> table) {
        return (InsertHelper<R>) insertHelperByTable.computeIfAbsent(table, t -> new InsertHelper<>(context, t));
    }

    public void newRecord() {
        insertHelperByTable.values().forEach(insertHelper -> {
            if (insertHelper.hasAddedRecords()) {
                insertHelper.newRecord();
            }
        });
    }

    public void executeIfRecordsAdded() {
        insertHelperByTable.values().forEach(InsertHelper::executeIfRecordsAdded);
    }
}
