package ru.yandex.direct.jooqmapperhelper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;

@ParametersAreNonnullByDefault
public class UpdateHelperAggregator {
    private final DSLContext dslContext;
    private final Set<TableField<?, Long>> idFields;
    private final Map<Table<?>, UpdateHelper<? extends Record>> updateHelperByTable;


    public UpdateHelperAggregator(DSLContext dslContext) {
        this.dslContext = dslContext;
        updateHelperByTable = new HashMap<>();
        idFields = new HashSet<>();
    }

    public <R extends Record> UpdateHelper<R> getOrCreate(TableField<R, Long> idField) {
        idFields.add(idField);
        return (UpdateHelper<R>) updateHelperByTable.computeIfAbsent(idField.getTable(),
                f -> new UpdateHelper<>(dslContext, idField));
    }

    public int execute() {
        return StreamEx.of(idFields)
                .map(this::execute)
                .foldLeft(Integer::sum)
                .orElse(0);
    }

    private <R extends Record> int execute(TableField<R, Long> idField) {
        return updateHelperByTable.get(idField.getTable()).execute();
    }

}
