package ru.yandex.direct.juggler;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class JugglerChecksStateFilter {

    @JsonProperty
    private final String host;
    @JsonProperty
    private final Set<String> tags;

    public JugglerChecksStateFilter(String host, Set<String> tags) {
        this.host = host;
        this.tags = tags;
    }

    public JugglerChecksStateFilter(String host, String... tags) {
        this(host, Arrays.stream(tags)
                .collect(Collectors.toSet()));
    }

    public String getHost() {
        return host;
    }

    public Set<String> getTags() {
        return tags;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JugglerChecksStateFilter that = (JugglerChecksStateFilter) o;
        return Objects.equal(host, that.host) &&
                Objects.equal(tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(host, tags);
    }
}
