package ru.yandex.direct.juggler;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@ParametersAreNonnullByDefault
public class JugglerChecksStateItem {
    private String host;
    private String service;
    private String status;
    private Double changeTime;
    private String description;

    @JsonCreator
    public JugglerChecksStateItem(@JsonProperty("host") String host,
                                  @JsonProperty("service") String service,
                                  @JsonProperty("status") String status,
                                  @JsonProperty("change_time") Double changeTime,
                                  @JsonProperty("description") String description) {
        this.host = host;
        this.service = service;
        this.status = status;
        this.changeTime = changeTime;
        this.description = description;
    }

    public String getHost() {
        return host;
    }

    public String getService() {
        return service;
    }

    public String getStatus() {
        return status;
    }

    public Double getChangeTime() {
        return changeTime;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JugglerChecksStateItem that = (JugglerChecksStateItem) o;
        return Objects.equal(host, that.host) &&
                Objects.equal(service, that.service) &&
                Objects.equal(status, that.status) &&
                Objects.equal(changeTime, that.changeTime) &&
                Objects.equal(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(host, service, status, changeTime, description);
    }
}
