package ru.yandex.direct.juggler;

import java.util.Arrays;
import java.util.List;

public interface JugglerClient extends AutoCloseable {
    void sendEvents(List<JugglerEvent> events);

    default void sendEvents(JugglerEvent... events) {
        sendEvents(Arrays.asList(events));
    }

    List<JugglerChecksStateItem> getChecksStateItems(JugglerChecksStateFilter filter);

    class FailedEventsException extends RuntimeException {
        private List<JugglerResponse.FailedEvent> failedEvents;

        FailedEventsException(List<JugglerResponse.FailedEvent> failedEvents) {
            super("Failed events: " + failedEvents);
            this.failedEvents = failedEvents;
            if (failedEvents.isEmpty()) {
                throw new IllegalArgumentException("failedEvents list must not be empty");
            }
        }

        public List<JugglerResponse.FailedEvent> getFailedEvents() {
            return failedEvents;
        }
    }

    void close();
}
